#include <iostream>
#include <string>
#include <curl/curl.h>

// Callback function to handle the response from the API
size_t WriteCallback(void* contents, size_t size, size_t nmemb, std::string* output) {
    size_t total_size = size * nmemb;
    output->append((char*)contents, total_size);
    return total_size;
}

int main() {
    // Initialize cURL
    CURL* curl = curl_easy_init();
    if (!curl) {
        std::cerr << "cURL initialization failed." << std::endl;
        return 1;
    }

    // API URL
    std::string url = "https://khilaadixpro.shop/api/check-order-status";

    // Form-Encoded Payload
    std::string payload = "user_token=2048f66bef68633fa3262d7a398ab577&order_id=8052313697";

    // Set cURL options
    curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
    curl_easy_setopt(curl, CURLOPT_POSTFIELDS, payload.c_str());
    curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, payload.size());

    // Response data
    std::string response_data;

    // Set the callback function to handle the response
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, &response_data);

    // Perform the POST request
    CURLcode res = curl_easy_perform(curl);

    // Check for errors
    if (res != CURLE_OK) {
        std::cerr << "cURL request failed: " << curl_easy_strerror(res) << std::endl;
    } else {
        // Request successful, print the response
        std::cout << "API Response:" << std::endl;
        std::cout << response_data << std::endl;
    }

    // Clean up cURL
    curl_easy_cleanup(curl);

    return 0;
}
