
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class KhilaadiXProSDK {

    private static String encodeParams(Map<String, String> params) {
        StringBuilder encodedParams = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (encodedParams.length() > 0) {
                    encodedParams.append('&');
                }
                encodedParams.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace(); // Handle the exception as per your requirements
            }
        }
        return encodedParams.toString();
    }

    public static String createOrder(String customerMobile, String userToken, String amount, String orderId, String redirectUrl, String remark1, String remark2) {
        try {
            URL url = new URL("https://khilaadixpro.shop/api/create-order");
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);

            Map<String, String> parameters = new HashMap<>();
            parameters.put("customer_mobile", customerMobile);
            parameters.put("user_token", userToken);
            parameters.put("amount", amount);
            parameters.put("order_id", orderId);
            parameters.put("redirect_url", redirectUrl);
            parameters.put("remark1", remark1);
            parameters.put("remark2", remark2);

            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(encodeParams(parameters));
            out.flush();
            out.close();

            int responseCode = conn.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String inputLine;
            StringBuffer response = new StringBuffer();

            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();

            return response.toString();
        } catch (Exception e) {
            e.printStackTrace(); // Handle the exception as per your requirements
            return null;
        }
    }

    public static void main(String[] args) {
        // Example usage
        String response = createOrder("8145344963", "e8d2a2f1ac98d41d3b7422fd11ab98fa", "1", "8787772321800", "https://khilaadixpro.shop", "testremark", "testremark2");
        System.out.println(response);
    }
}
