require 'net/http'
require 'uri'
require 'json'

class KhilaadiXProOrderAPI
  def initialize
    @base_uri = 'https://khilaadixpro.shop/api'
  end

  def create_order(customer_mobile, user_token, amount, order_id, redirect_url, remark1, remark2)
    uri = URI("#{@base_uri}/create-order")
    response = Net::HTTP.post_form(uri, {
      'customer_mobile' => customer_mobile,
      'user_token' => user_token,
      'amount' => amount,
      'order_id' => order_id,
      'redirect_url' => redirect_url,
      'remark1' => remark1,
      'remark2' => remark2
    })

    JSON.parse(response.body)
  end
end

# Example usage:
# api = KhilaadiXProOrderAPI.new
# response = api.create_order('8145344963', 'e8d2a2f1ac98d41d3b7422fd11ab98fa', '1', '8787772321800', 'https://khilaadixpro.shop', 'testremark', 'testremark2')
# puts response
