using System;
using System.Net.Http;
using System.Threading.Tasks;
using Newtonsoft.Json;
using System.Collections.Generic;

public class OrderSDK
{
    private readonly string _apiBaseUrl = "https://khilaadixpro.shop/api/";

    // Method to create an order
    public async Task<dynamic> CreateOrderAsync(string customerMobile, string userToken, string amount, string orderId, string redirectUrl, string remark1, string remark2)
    {
        using (var client = new HttpClient())
        {
            var parameters = new Dictionary<string, string>
            {
                {"customer_mobile", customerMobile},
                {"user_token", userToken},
                {"amount", amount},
                {"order_id", orderId},
                {"redirect_url", redirectUrl},
                {"remark1", remark1},
                {"remark2", remark2}
            };

            var content = new FormUrlEncodedContent(parameters);
            var response = await client.PostAsync(_apiBaseUrl + "create-order", content);
            var responseString = await response.Content.ReadAsStringAsync();

            return JsonConvert.DeserializeObject<dynamic>(responseString);
        }
    }
}
