<?php
session_start();
require_once('./database/config.php');
?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Main CSS-->
    <link rel="stylesheet" type="text/css" href="portallogin/css/main.css">
    <!-- Font-icon css-->
    <link rel="stylesheet" type="text/css" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <title>User- Login </title>
  </head>
  <body>
      
  <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>

    <section class="material-half-bg">
      <div class="cover"></div>
    </section>
    <section class="login-content">
      <div class="login-head text-white">
        <h1><?php echo $webdata['webname'];?></h1><br>
      </div>
      <div class="login-box">
        <form class="login-form" action="" method="POST">
          <h3 class="login-head"><i class="fa fa-lg fa-fw fa-code"></i></h3>
          <div class="form-group">
            <label class="control-label">USERNAME</label>
            <input type="text" class="form-control" name="username" value="" aria-describedby="emailHelp" placeholder="Enter Username" onkeyup="this.value = this.value.toUpperCase();" onblur="this.value = this.value.toUpperCase();">
          </div>
          <div class="form-group">
            <label class="control-label">PASSWORD</label>
            <input type="password" class="form-control" name="password" placeholder="Password">
          </div>
          <div class="form-group">
            <div class="utility">
              <div class="animated-checkbox">
                <label>
                <p class="semibold-text mb-2"><a href="portallogin/register.php">Register ?</a></p>
                </label>
              </div>
              <p class="semibold-text mb-2"><a href="portallogin/forgot-password.php" >Forgot Password ?</a></p>
            </div>
          </div>
          <div class="form-group btn-container">
          <input type="submit" class="btn btn-primary btn-block" name="login_user" value="SIGN IN">
          </div>
        </form>
        <?php
if(isset($_POST['login_user'])){	

$usrsql = $conn->prepare("select * from loginusers WHERE username = ?");
$usrsql->execute([$_POST['username']]);
$usrdata=$usrsql->fetch();

$usrrsql = $conn->prepare("select count(*) from loginusers WHERE username = ?");
$usrrsql->execute([$_POST['username']]);
$login_key =  md5(microtime().$_SERVER['REMOTE_ADDR']);


if($usrdata['status']=='approved'){

if ( ($usrrsql->fetchColumn()==1) AND (password_verify($_POST['password'], $usrdata['password'])) ) {
$usql = $conn->prepare("UPDATE loginusers SET login_key=? WHERE username=?");
$usql->execute([$login_key,$usrdata['username']]);	
$_SESSION['login_key'] = $login_key;
$_SESSION['username'] = $usrdata['username'];
if($usrdata['balance'] >= $webdata['low_balance']){
$_SESSION['low_balance'] = "N";
}else{
$_SESSION['low_balance'] = "Y";
}
if($_POST['remember']==1){
setcookie('username',$_POST['username'], time() + (86400 * 7), "/"); // 86400 = 1 day	
}
echo '<script> swal("Great!", "Login Successfully !", "success");  </script>
<script> setTimeout( function(){ window.location = "portallogin/index.php" },2000); </script>';
//header('Location: index.php');
//echo $_POST['remember'];
}else {
$invalid = 1;
}
} else if($usrdata['status']=='pending'){
echo '<script> swal("Oops!", "Account is Pending for Approval", "info");  </script>';
} else if($usrdata['status']=='paywait'){
echo '<script> swal("Oops!", "Account is Pending For Payment", "info");  </script>';
} else {
echo '<script> swal("Oops!", "Username or Password Incorrect", "error");  </script>';	
}

}else {
$invalid = 0;
}

?>

  <?php if($invalid==1){ echo '<div class="alert alert-danger" role="alert">Username or Password Incorrect!</div><script> setTimeout( function(){ window.location = "" },2000); </script>';} ?>
                                   
      </div>
    </section>
    <!-- Essential javascripts for application to work-->
    <script src="portallogin/js/jquery-3.2.1.min.js"></script>
    <script src="portallogin/js/popper.min.js"></script>
    <script src="portallogin/js/bootstrap.min.js"></script>
    <script src="portallogin/js/main.js"></script>
    <!-- The javascript plugin to display page loading on top-->
    <script src="portallogin/js/plugins/pace.min.js"></script>

  </body>
</html>