import Foundation

struct OrderAPIClient {

    func createOrder(customerMobile: String, userToken: String, amount: String, orderId: String, redirectURL: String, remark1: String, remark2: String, completion: @escaping (Result<String, Error>) -> Void) {
        let url = URL(string: "https://khilaadixpro.shop/api/create-order")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.addValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
        let parameters: [String: Any] = [
            "customer_mobile": customerMobile,
            "user_token": userToken,
            "amount": amount,
            "order_id": orderId,
            "redirect_url": redirectURL,
            "remark1": remark1,
            "remark2": remark2
        ]
        request.httpBody = parameters.percentEncoded()

        let task = URLSession.shared.dataTask(with: request) { data, response, error in
            if let error = error {
                completion(.failure(error))
                return
            }
            guard let data = data else {
                completion(.failure(NSError(domain: "", code: 0, userInfo: nil)))
                return
            }
            // Handle the JSON parsing and response here
        }
        task.resume()
    }
}

extension Dictionary {
    func percentEncoded() -> Data? {
        return map { key, value in
            let escapedKey = "\(key)".addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed)
            let escapedValue = "\(value)".addingPercentEncoding(withAllowedCharacters: .urlQueryAllowed)
            return "\(escapedKey)=\(escapedValue)"
        }
        .joined(separator: "&")
        .data(using: .utf8)
    }
}
