import io.ktor.application.*
import io.ktor.request.*
import io.ktor.response.*
import io.ktor.routing.*
import io.ktor.server.engine.embeddedServer
import io.ktor.server.netty.Netty

fun main() {
    embeddedServer(Netty, port = 8080) {
        routing {
            post("/webhook") {
                val parameters = call.receiveParameters()
                val status = parameters["status"]
                val orderId = parameters["order_id"]
                val remark1 = parameters["remark1"]

                if (status == "SUCCESS") {
                    // Process the data here as needed
                    // For example, log it or perform other actions

                    // Respond to the webhook with a success message
                    call.respondText("Webhook received successfully", ContentType.Text.Plain)
                } else {
                    // Respond with an error message if the status is not "SUCCESS"
                    call.response.status(HttpStatusCode.BadRequest)
                    call.respondText("Invalid status: $status", ContentType.Text.Plain)
                }
            }
        }
    }.start(wait = true)
}
